<?php

include "config.php";

// Fetch signal packages
$sql = "SELECT * FROM signal_packages";
$result = $conn->query($sql);

// Generate dropdown options dynamically
$options = "";
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $options .= '<option value="' . $row['id'] . '" 
                        data-price="' . $row['price'] . '" 
                        data-accuracy="' . $row['accuracy'] . '" 
                        data-duration="' . $row['duration'] . '"
                        data-pname="' . $row['name'] . '"
                        data-roi="' . $row['roi'] . '" 
                        style="color: #000;">
                        ' . $row['name'] . '
                     </option>';
    }
}
$conn->close();

?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Investing Packages</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/4.6.2/css/bootstrap.min.css" integrity="sha512-rt/SrQ4UNIaGfDyEXZtNcyWvQeOq0QLygHluFQcSjaGB04IxWhal71tKuzP6K8eYXYB6vJV4pHkXcmFGGQ1/0w==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" type="text/css" href="assets/css/css2.css">
    <link rel="stylesheet" type="text/css" href="assets/css/deposit.css">
    <link rel="stylesheet" type="text/css" href="assets/css/css.css">
    <link rel="stylesheet" type="text/css" href="assets/css/dashboard.css">
    <link rel="stylesheet" type="text/css" href="assets/css/sidebar.css">
    <style>
        body {
            font-family: 'Roboto' !important;
        }

        .investment-form {
            max-width: 500px;
            margin: 20px auto;
            padding: 20px;
            background: #1e1e1e;
            color: #fff;
            border-radius: 8px;
        }

        .submit-btn {
            background-color: #22b21f;
            border: none;
            padding: 10px;
            color: white;
            cursor: pointer;
        }

        .submit-btn:hover {
            background-color: #1a9518;
        }

        .modal-content {
            background-color: #1e1e1e;
            color: #fff;
        }

        #countdown {
            font-size: 24px;
            font-weight: bold;
            color: #ffcc00;
        }
    </style>
</head>

<body style="background:url('assets/images/mask_group.svg');background-color:#000;">

    <section class="">
        <div class="justify-content-between" style="margin-top:-35px;">

            <div class="content">

                <div class="ddown">
                    <div class="linklist">
                        <a href="profile.php">Profile</a>
                    </div>
                    <a href="logout.php">
                        <div class="logout">logout </div>
                    </a>
                </div>

                <div class="top">
                    <div class="menu2" id="menu">
                    </div>
                    <div class="top-m">
                        <div><?= $user["username"] ?></div>
                        <div class="verified"></div>
                    </div>
                    <div class="right">
                        <div class="nameicon" id="nameicon" data-name="Trojan">
    						<div id="name">
    							<span><?= strtoupper(substr($user["username"], 0, 1)) ?></span>
    						</div>
                        </div>
                    </div>
                </div>

                <div class="sidebar" id="sidebar" style="background-color:#141414;">
                    <div class="logo">
                        <img src="assets/images/logo.svg" width="150px">
                    </div>

                    <div class="chil">
                        <div class="linklist">

                            <a href="dashboard.php" data-highlight="url">
                                <img src="assets/images/p.svg">
                                <div class="title">Portfolio
                                </div>
                            </a>

                            <a href="deposit.php" data-highlight="url">
                                <img src="assets/images/d.svg">
                                <div class="title">Deposit
                                </div>
                            </a>

                            <a href="withdrawal.php" data-highlight="url">
                                <img src="assets/images/w.svg">
                                <div class="title">Withdraw
                                </div>
                            </a>

                            <a href="live-trading.php" data-highlight="url">
                                <img src="assets/images/t.svg">
                                <div class="title">Trades
                                </div>
                            </a>

                            <a href="account-upgrade.php" data-highlight="url">
                                <img src="assets/images/s.svg">
                                <div class="title">Subscription
                                </div>
                            </a>

                            <a href="trading-stock.php" data-highlight="url">
                                <img src="assets/images/sk.svg">
                                <div class="title">Stocks
                                </div>
                            </a>

                            <a href="signal-package.php" data-highlight="url">
                                <img src="assets/images/sg.svg">
                                <div class="title">Signal
                                </div>
                            </a>

                            <a href="traders.php" data-highlight="url">
                                <img src="assets/images/c.svg">
                                <div class="title">Copy Experts
                                </div>
                            </a>

                            <a href="transactions.php" data-highlight="url">
                                <img src="assets/images/assets.svg">
                                <div class="title">Transactions
                                </div>
                            </a>
                            
							<a href="trades.php" data-highlight="url">
								<img src="assets/images/assets.svg">
								<div class="title">Trades
								</div>
							</a>

                            <?php if ($user['verified'] == 0) : ?>
                                <a href="verify.php" data-highlight="url">
                                    <img src="assets/images/verify.svg" alt="Verify Account">
                                    <div class="title">Verify Account</div>
                                </a>
                            <?php endif; ?>

                            <a href="logout.php" data-highlight="url">
                                <img src="assets/images/logout.svg">
                                <div class="title">Logout
                                </div>
                            </a>

                        </div>
                    </div>

                    <div class="tail" style="margin-top:-75px;">
                        <div class="drip">
                            <div class="img">
                                <img src="assets/images/pers.svg">
                            </div>
                            <div class="tailr">
                                <div class="tailr1"><?= $user["username"] ?></div>
                                <div class="tailr1"><?= $user["account_type"] ?></div>
                            </div>
                        </div>
                    </div>

                </div>
                
                
				<div style="margin-top:12px;">
					<p align="center" class="text-uppercase">GET SIGNALS</p>
				</div>
				
				<div class="amount-card" style="margin-top: 5%;">

					<div style="margin-top: 5%;">
						<label class="a2">Choose Your Payment Method From The List Below</label>
						<input class="form-control  b" placeholder="Search Method" id="myInput">
					</div>

					<div class="myTable">
						<div class="dtype" type="button" data-toggle="modal" data-target="#exampleModal" data-method="BITCOIN">
							<span class="txt">BITCOIN</span>
						</div>
						<div class="dtype" type="button" data-toggle="modal" data-target="#exampleModal" data-method="ETHEREUM">
							<span class="txt">ETHEREUM</span>
						</div>
						<div class="dtype" type="button" data-toggle="modal" data-target="#exampleModal" data-method="LITECOIN">
							<span class="txt">LITECOIN</span>
						</div>
						<div class="dtype" type="button" data-toggle="modal" data-target="#exampleModal" data-method="BITCOINCASH">
							<span class="txt">BITCOINCASH</span>
						</div>
						<div class="dtype" type="button" data-toggle="modal" data-target="#exampleModal" data-method="XRP_Ripple">
							<span class="txt">XRP_Ripple</span>
						</div>
						<div class="dtype" type="button" data-toggle="modal" data-target="#exampleModal" data-method="SOL_Solana">
							<span class="txt">SOL_Solana</span>
						</div>
						<div class="dtype" type="button" data-toggle="modal" data-target="#exampleModal" data-method="USDT_Tether">
							<span class="txt">USDT_Tether</span>
						</div>
						<div class="dtype" type="button" data-toggle="modal" data-target="#exampleModal" data-method="Dogecoin">
							<span class="txt">Dogecoin</span>
						</div>
						<div class="dtype" type="button" data-toggle="modal" data-target="#exampleModal" data-method="Shiba">
							<span class="txt">Shiba</span>
						</div>
					</div>
				</div>
            </div>
            
        </div>
    </section>
    
    
	<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered">
			<div class="modal-content">
				<div class="modal-body">
					<div class="d-flex justify-content-between">
						<p class="mb-txt">You are to make payment using the selected method <br><br> Screenshot and upload proof of payment</p>
						<img src="assets/images/c(1).svg" id="close-btn">
					</div>

					<form action="assets/php/subscribe.php" method="post" enctype="multipart/form-data">

						<div id="method-name"></div>
      
      					<label>Select Signal Package:</label>
                        <select class="form-control" id="signal-package" required>
                            <option value="" style="color: #000;">-- Select a Package --</option>
                            <option value="beginner" style="color: #000;" >Beginner Signals - $2000
</option>
                            <option value="pro" style="color: #000;" >Pro Signals - $4500
</option>
                            <option value="vip" style="color: #000;" >VIP Signals - $9500</option>
                        </select>

						<div id="method-address">Address:</div>
						<div id="method-address-value">
							<div class="d-flex justify-content-center instr" id="wallet-address"></div>
						</div>

						<div class="copy">
							<div class="d-flex justify-content-center instr" id="copy-address"><span>Tap to copy address</span></div>
						</div>

						<div class="d-flex justify-content-center">
							<div class="method-img">
                            	<img id="qrcode" src="" alt="QR Code" style="max-width: 200px;">
                            </div>
						</div>

						<input type="hidden" name="paymentmethod" id="paymentmethod" value="">
						<input type="hidden" name="user_id" id="user_id" value="<?= $user['id'] ?>">

						<div class="upload-label">
							Upload Payment Proof After Payment:
						</div>
                        						
                        <div class="fil">
                            <div class="d-flex align-items-center">
                                <label for="ChooseFile" id="cfile" class="btn btn-outline-primary">Choose File</label>
                                <input type="file" id="ChooseFile" name="requestProof" accept="image/*" class="custom-file-input" required style="display: none;">
                                <span id="fileStatus" style="margin-left: 10px; color: red;">No file selected</span>
                            </div>
                        </div>
                        
                        <div>
                            <br>
                          <!--<label for="description">Description</label>-->
                            <textarea class="form-control" name="description" id="description" placeholder="Narration" rows="4" required></textarea>
                        </div>

						<br>
						<div class="d-flex">
							<button class="submit" name="uprequest" type="submit">Submit</button>
						</div>
					</ v
					
					<p>&nbsp;</p>
				</div>
			</div>
		</div>
	</div>
    
    <!-- Subscription Modal -->
    <div class="modal fade" id="signalModal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Subscription Details</h5>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body text-center">
                    <p><strong>Package:</strong> <span id="modal-signal-package"></span></p>
                    <p><strong>Subscription Fee:</strong> $<span id="modal-price"></span></p>
                    <p><strong>Signal Accuracy:</strong> <span id="modal-accuracy"></span>%</p>
                    <p><strong>Duration:</strong> <span id="modal-signal-duration"></span> Days</p>
                    <p><strong>Expected ROI:</strong> <span id="modal-roi"></span>%</p>
                    <p><strong>Your Balance:</strong> $<span id="user-balance"><?= number_format($user['balance'], 2); ?></span></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-success" id="buy-now">Buy Now</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>


    <script src="assets/js/sidebar.js"></script>
    <script src="assets/js/dashboard.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/2.11.8/umd/popper.min.js" integrity="sha512-TPh2Oxlg1zp+kz3nFA0C5vVC6leG/6mm1z9+mA81MI5eaUVqasPLO8Cuk4gMF4gUfP5etR73rgU/8PNMsSesoQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/4.6.2/js/bootstrap.min.js" integrity="sha512-7rusk8kGPFynZWu26OKbTeI+QPoYchtxsmPeBqkHIEXJxeun4yJ4ISYe7C6sz9wdxeE1Gk3VxsIWgCZTc+vX3g==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>


    // <script>
        
    //     $(document).ready(function() {
    //         $("#signal-form").submit(function(event) {
    //             event.preventDefault();
        
    //             let signalPackage = $("#signal-package option:selected");
        
    //             if (signalPackage.val() === "") {
    //                 alert("Please select a signal package.");
    //                 return;
    //             }
        
    //             let packageName = signalPackage.data("pname");
    //             let price = parseFloat(signalPackage.data("price"));
    //             let accuracy = signalPackage.data("accuracy");
    //             let duration = signalPackage.data("duration");
    //             let roi = signalPackage.data("roi");
    //             let userBalance = <?= $user['balance']?>;
        
    //             $("#modal-signal-package").text(packageName);
    //             $("#modal-price").text(price);
    //             $("#modal-accuracy").text(accuracy);
    //             $("#modal-signal-duration").text(duration);
    //             $("#modal-roi").text(roi);
        
    //             $("#signalModal").modal("show");
        
    //             $("#buy-now").off("click").on("click", function() {
    //                 if (userBalance < price) {
    //                     alert(`Insufficient balance. Please deposit funds. User Balance = ${userBalance} and Price = ${price}`);
    //                     return;
    //                 }
        
    //                 $.ajax({
    //                     type: "POST",
    //                     url: "assets/php/subscribe.php",
    //                     data: {
    //                         user_id: <?= $user['id'] ?>,
    //                         package_name: packageName,
    //                         price: price,
    //                         accuracy: accuracy,
    //                         duration: duration,
    //                         roi: roi
    //                     },
    //                     success: function(response) {
    //                         alert(response);
    //                         $("#signalModal").modal("hide");
    //                         location.reload();
    //                     },
    //                     error: function() {
    //                         alert("Error processing request.");
    //                     }
    //                 });
    //             });
    //         });
    //     });

    // </script>
    
    <script>
		document.addEventListener("DOMContentLoaded", handleURLMessage);

		// Handle message from URL and display it using SweetAlert
		function handleURLMessage() {
			const urlParams = new URLSearchParams(window.location.search);
			const message = urlParams.get('message');
			const messageType = urlParams.get('message_type');

			if (message) {
				const iconType = messageType === "success" ? "success" : "error"; // Define icon based on type

				swal.fire({
					title: iconType === "success" ? "Success!" : "Error!",
					text: decodeURIComponent(message),
					icon: iconType,
					confirmButtonText: "OK"
				});

				// Remove message from URL after displaying
				history.replaceState(null, '', window.location.pathname);
			}
		}


		document.addEventListener("DOMContentLoaded", function() {
			const cryptoButtons = document.querySelectorAll(".dtype");

            cryptoButtons.forEach(button => {
            	button.addEventListener("click", function() {
            		let method = this.getAttribute("data-method");
            
            		// Update modal fields
            		document.getElementById("method-name").textContent = method;
            		document.getElementById("paymentmethod").value = method;
            
            		// Fetch wallet address and QR image
            		fetch(`assets/php/fetch_wallet.php?method=${method}`)
            			.then(response => response.json())
            			.then(data => {
            				document.getElementById("wallet-address").textContent = data.wallet;
            				document.getElementById("copy-address").setAttribute("data-clipboard-text", data.wallet);
            				
            				// Set QR image
            				const qrImg = document.getElementById("qrcode");
            				qrImg.src = data.qr_code;
            				qrImg.alt = `${method} QR Code`;
            			})
            			.catch(error => console.error("Error fetching wallet:", error));
            	});
            });


			// Copy wallet address on click
			document.getElementById("copy-address").addEventListener("click", function() {
				navigator.clipboard.writeText(this.getAttribute("data-clipboard-text")).then(() => {
					alert("Wallet address copied!");
				});
			});
		});
	</script>
	
    <script>
        $(document).ready(function () {
            $("#close-btn").click(function () {
                $("#exampleModal").modal("hide");
            });
        });
    </script>
    
    <script>
        const fileInput = document.getElementById('ChooseFile');
        const fileStatus = document.getElementById('fileStatus');
    
        fileInput.addEventListener('change', function () {
            if (fileInput.files.length > 0) {
                fileStatus.textContent = "Selected: " + fileInput.files[0].name;
                fileStatus.style.color = "green";
            } else {
                fileStatus.textContent = "No file selected";
                fileStatus.style.color = "red";
            }
        });
    </script>


</body>

</html>