<?php
session_start();
include "../../../assets/php/connection.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user_id = intval($_POST['user_id']);
    $package_name = trim($_POST['package_name']);

    // 5. Insert subscription
    $stmt = $conn->prepare("INSERT INTO subscriptions_v2 (user_id, signal_package, subscribed_at) VALUES (?, ?, NOW())");
    $stmt->bind_param("is", $user_id, $package_name);

    if ($stmt->execute()) {
        $message = urlencode("Subscription successful!");
        $type = "success";
    } else {
        $message = urlencode("Subscription failed.");
        $type = "error";
    }

    $stmt->close();
    $conn->close();

    header("Location: ../../signal-package.php?message=$message&message_type=$type");
}
