<?php
include "../../../assets/php/connection.php";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    function cleanInput($data) {
        return htmlspecialchars(stripslashes(trim($data)));
    }

    $user_id = cleanInput($_POST['user_id']);
    $stock = cleanInput($_POST['stock']);
    $trade_pair = cleanInput($_POST['trade_pair']);
    $lot_size = floatval($_POST['lot_size']);
    $entry_price = floatval($_POST['entry_price']);
    $stop_loss = floatval($_POST['stop_loss']);
    $take_profit = floatval($_POST['take_profit']);
    $trading_action = cleanInput($_POST['trading_action']);
    $user_signal_strength = intval($_POST['user_signal_strength']);

    // Determine win/loss based on signal strength
    $randomChance = rand(1, 100);
    $result = ($randomChance <= $user_signal_strength) ? 'win' : 'loss';

    // Deduct trade amount from balance
    $updateBalance = $conn->prepare("UPDATE users SET balance = balance - ? WHERE id = ?");
    $updateBalance->bind_param("di", $entry_price, $user_id);
    $updateBalance->execute();
    $updateBalance->close();

    // Store trade in database with result
    $query = "INSERT INTO live_trading_v2 
        (user_id, stock, trade_pair, lot_size, entry_price, stop_loss, take_profit, trading_action, result, created_at) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())";

    $stmt = $conn->prepare($query);
    $stmt->bind_param("issddddss", $user_id, $stock, $trade_pair, $lot_size, $entry_price, $stop_loss, $take_profit, $trading_action, $result);

    if ($stmt->execute()) {
        $message = urlencode("You have successfully traded $trade_pair.<br>Your trade is now active.");
        $type = "success";
    } else {
        $message = urlencode("Failed to process trade.");
        $type = "error";
    }

    $stmt->close();
    $conn->close();

    header("Location: ../../live-trading.php?message=$message&message_type=$type");
}

































// include "../../../assets/php/connection.php";

// if ($_SERVER["REQUEST_METHOD"] == "POST") {
//     // Sanitize input
//     function cleanInput($data)
//     {
//         return htmlspecialchars(stripslashes(trim($data)));
//     }

//     $user_id = cleanInput($_POST['user_id']);
//     $stock = cleanInput($_POST['stock']);
//     $trade_pair = cleanInput($_POST['trade_pair']);
//     $lot_size = floatval($_POST['lot_size']);
//     $entry_price = floatval($_POST['entry_price']);
//     $stop_loss = floatval($_POST['stop_loss']);
//     $take_profit = floatval($_POST['take_profit']);
//     $trading_action = cleanInput($_POST['trading_action']);
//     $user_signal_strength = cleanInput($_POST['user_signal_strength']);

//     // Deduct trade amount from balance immediately
//     $updateBalance = $conn->prepare("UPDATE users SET balance = balance - ? WHERE id = ?");
//     $updateBalance->bind_param("di", $entry_price, $user_id);
//     $updateBalance->execute();
//     $updateBalance->close();

//     // Store trade result in database
//     $query = "INSERT INTO live_trading_v2 
//         (user_id, stock, trade_pair, lot_size, entry_price, stop_loss, take_profit, trading_action, created_at) 
//         VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW())";

//     $stmt = $conn->prepare($query);
//     $stmt->bind_param("issdddds", $user_id, $stock, $trade_pair, $lot_size, $entry_price, $stop_loss, $take_profit, $trading_action);

//     if ($stmt->execute()) {
//         // echo json_encode(["status" => "success"]);
//         $message = urlencode("Trade submitted successfully.");
//         $type = "success";
//     } else {
//         // echo json_encode(["status" => "error", "message" => "Failed to process trade."]);
//         $message = urlencode("Failed to process trade.");
//         $type = "error";
//     }

//     $stmt->close();
//     $conn->close();
    
//     header("Location: ../../live-trading.php?message=$message&message_type=$type");
// }
