<?php
include "../../../assets/php/connection.php";

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['verify_account'])) {
    $user_id = $_POST['user_id'] ?? null;

    if (!$user_id) {
        header("Location: ../../verify.php?message=" . urlencode("Invalid user.") . "&message_type=error");
        exit();
    }

    // File Upload Handling
    $upload_dir = '../uploads/';
    if (!file_exists($upload_dir)) {
        mkdir($upload_dir, 0777, true);
    }

    function uploadFile($file, $upload_dir, $prefix) {
        $filename = $prefix . '_' . time() . '_' . basename($file['name']);
        $target_file = $upload_dir . $filename;

        // Validate file type
        $allowed_types = ['image/jpeg', 'image/png', 'image/jpg'];
        if (!in_array($file['type'], $allowed_types)) {
            return false;
        }

        if (move_uploaded_file($file['tmp_name'], $target_file)) {
            return $filename;
        }
        return false;
    }

    $selfie = uploadFile($_FILES['pic'], $upload_dir, 'selfie');
    $id_front = uploadFile($_FILES['idcardFront'], $upload_dir, 'id_front');
    $id_back = uploadFile($_FILES['idcardBack'], $upload_dir, 'id_back');

    if ($selfie && $id_front && $id_back) {
        // Insert into database
        $stmt = $conn->prepare("INSERT INTO kyc_verifications (user_id, selfie, id_front, id_back, status, submitted_at) VALUES (?, ?, ?, ?, 'pending', NOW())");
        $stmt->bind_param("isss", $user_id, $selfie, $id_front, $id_back);

        if ($stmt->execute()) {
            header("Location: ../../verify.php?message=" . urlencode("KYC submitted successfully. Awaiting approval.") . "&message_type=success");
            exit();
        } else {
            header("Location: ../../verify.php?message=" . urlencode("Error submitting KYC. Please try again.") . "&message_type=error");
            exit();
        }

        $stmt->close();
    } else {
        header("Location: ../../verify.php?message=" . urlencode("File upload failed. Ensure images are JPG/PNG.") . "&message_type=error");
        exit();
    }

    $conn->close();
}