<?php
include "../../../assets/php/connection.php";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $id = intval($_POST['id']);

    $query = "UPDATE live_trading_v2 SET session = 'close' WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $id);
    
    if ($stmt->execute()) {
        // echo json_encode(["status" => "success"]);
        $message = urlencode("Trade ended successfully.");
        $type = "success";
    } else {
        // echo json_encode(["status" => "error", "message" => "Failed to process trade."]);
        $message = urlencode("Failed to end trade.");
        $type = "error";
    }

    $stmt->close();
    $conn->close();
    
    header("Location: ../../live-trading.php?message=$message&message_type=$type");
}