<?php
include "../../../assets/php/connection.php";
require_once "../../../admin/assets/php/send_email.php";

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    // Function to sanitize input
    function cleanInput($data) {
        return htmlspecialchars(strip_tags(trim($data)));
    }

    $email = isset($_POST['email']) ? cleanInput($_POST['email']) : null;

    if (!$email) {
        header("Location: ../../forgot-password.php?message=" . urlencode("Email is required!") . "&message_type=danger");
        exit();
    }

    // Check if user exists
    $query = "SELECT id, fullname, email FROM users WHERE email = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param('s', $email);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();

    if (!$user) {
        header("Location: ../../forgot-password.php?message=" . urlencode("If this email exists in our system, a reset link has been sent.") . "&message_type=success");
        exit();
    }
    
    // Generate a unique token for password reset
    $token = bin2hex(random_bytes(32));
    $expiry = date("Y-m-d H:i:s", time() + 3600); // Token valid for 1 hour
    
    // Store the token in database
    $query = "UPDATE users SET reset_token = ?, reset_token_expiry = ? WHERE email = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param('sss', $token, $expiry, $email);
    $stmt->execute();
    
    // Create reset link
    $resetLink = "https://bitpromarketprime.live/auth/reset-password.php?token=$token";
    
    // Email content
    $subject = "Password Reset Request";
    
    $message = '
    <!DOCTYPE html>
    <html>
    <head>
        <title>Password Reset</title>
        <style>
            @import url(\'https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap\');
            
            body {
                font-family: \'Poppins\', Arial, sans-serif;
                line-height: 1.6;
                color: #333333;
                margin: 0;
                padding: 20px;
                background-color: #f0f0f0 !important; /* Light gray background */
                -webkit-text-size-adjust: 100%;
                -ms-text-size-adjust: 100%;
            }
            .email-wrapper {
                background-color: #f0f0f0;
                padding: 20px;
            }
            .email-container {
                max-width: 600px;
                margin: 0 auto;
                background-color: #ffffff;
                border-radius: 8px;
                overflow: hidden;
                box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            }
            .header {
                text-align: center;
                padding: 30px 20px 20px;
                background-color: #708090;
                border-bottom: 1px solid #eeeeee;
            }
            .logo {
                max-width: 180px;
                height: auto;
                margin-bottom: 20px;
            }
            .content {
                padding: 30px;
                background-color: #ffffff;
            }
            h1 {
                color: #2c3e50;
                font-size: 24px;
                font-weight: 600;
                margin-top: 0;
                margin-bottom: 20px;
            }
            p {
                margin-bottom: 20px;
                font-size: 15px;
                color: #555555;
            }
            .reset-button {
                display: inline-block;
                padding: 12px 30px;
                background-color: #4CAF50;
                color: white !important;
                text-decoration: none;
                border-radius: 5px;
                font-weight: 500;
                margin: 25px 0;
                text-align: center;
            }
            .footer {
                padding: 20px;
                text-align: center;
                font-size: 12px;
                color: #ffffff;
                background-color: #708090;
                border-top: 1px solid #eeeeee;
            }
            .footer a {
                color: #4CAF50 !important;
                text-decoration: none;
            }
            @media only screen and (max-width: 600px) {
                .email-container {
                    width: 100% !important;
                    border-radius: 0 !important;
                }
                .content {
                    padding: 20px !important;
                }
            }
        </style>
    </head>
    <body>
        <div class="email-wrapper">
            <div class="email-container">
                <div class="header">
                    <!-- Replace with your logo URL -->
                    <img src="https://bitpromarketprime.live/auth/assets/images/logo.png" class="logo" alt="Bitpro Market Prime Logo">
                </div>
                
                <div class="content">
                    <h1>Hi '.htmlspecialchars($user['fullname']).',</h1>
                    <p>We received a request to reset your password. Click the button below to proceed:</p>
                    
                    <p style="text-align: center;">
                        <a href="'.$resetLink.'" class="reset-button">Reset Password</a>
                    </p>
                    
                    <p>This link will expire in 1 hour. If you didn\'t request this password reset, please ignore this email or contact our support team.</p>
                    
                    <p>Best regards,<br><strong>The Support Team</strong></p>
                </div>
                
                <div class="footer">
                    <p>&copy; '.date('Y').' Bitpro Market Prime. All rights reserved.</p>
                </div>
            </div>
        </div>
    </body>
    </html>
    ';
    
    // Send email
    $sendEmail = sendNotificationEmail($email, $message, $subject);
    
    if ($sendEmail) {
        header("Location: ../../forgot-password.php?message=" . urlencode("If this email exists in our system, a reset link has been sent.") . "&message_type=success");
    } else {
        header("Location: ../../forgot-password.php?message=" . urlencode("Failed to send reset email. Please try again.") . "&message_type=danger");
    }
    exit();
} else {
    header("Location: ../../forgot-password.php?message=" . urlencode("Invalid request method.") . "&message_type=danger");
    exit();
}