<?php
// include "../../../assets/php/connection.php";

// if ($_SERVER["REQUEST_METHOD"] === "POST") {
//     // Function to sanitize input
//     function cleanInput($data)
//     {
//         return htmlspecialchars(strip_tags(trim($data)));
//     }

//     $password_confirm = isset($_POST['password_confirm']) ? cleanInput($_POST['password_confirm']) : null;
//     $password = isset($_POST['password']) ? $_POST['password'] : null;
//     $token = isset($_POST['token']) ? $_POST['token'] : null;

//     if (!$password_confirm || !$password || !$token) {
//         header("Location: ../../login.php?message=" . urlencode("All fields are required!") . "&message_type=danger");
//         exit();
//     }

//     // Hash the new password
//     $password_hash = password_hash($password, PASSWORD_DEFAULT);
    
//     // Update user's password and clear reset token
//     $query = "UPDATE users SET password_hash = ?, password = ?, reset_token = NULL, reset_token_expiry = NULL WHERE reset_token = ?";
//     $stmt = $conn->prepare($query);
//     $stmt->bind_param('sss', $password_hash, $password, $token);
    
//     if ($stmt->execute()) {
//         header("Location: ../../login.php?message=" . urlencode("Password has been reset successfully. Please login with your new password.") . "&message_type=success");
//         exit();
//     } else {
//         header("Location: ../../reset-password.php?token=$token&message=" . urlencode("Failed to reset password. Please try again.") . "&message_type=danger");
//         exit();
//     }
// }



include "../../../assets/php/connection.php";
require_once "../../../admin/assets/php/send_email.php";

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    try {
        // Function to sanitize input
        function cleanInput($data) {
            return htmlspecialchars(strip_tags(trim($data)));
        }

        $password_confirm = isset($_POST['password_confirm']) ? cleanInput($_POST['password_confirm']) : null;
        $password = isset($_POST['password']) ? $_POST['password'] : null;
        $token = isset($_POST['token']) ? cleanInput($_POST['token']) : null;

        // Validate inputs
        if (!$password_confirm || !$password || !$token) {
            throw new Exception("All fields are required!");
        }

        if ($password !== $password_confirm) {
            throw new Exception("Passwords do not match!");
        }

        if (strlen($password) < 8) {
            throw new Exception("Password must be at least 8 characters long!");
        }

        // Begin database transaction
        $conn->begin_transaction();

        try {
            // Get user details (with FOR UPDATE to lock the row)
            $query = "SELECT id, email, fullname FROM users WHERE reset_token = ? FOR UPDATE";
            $stmt = $conn->prepare($query);
            
            if (!$stmt) {
                throw new Exception("Database prepare error: " . $conn->error);
            }
            
            $stmt->bind_param('s', $token);
            
            if (!$stmt->execute()) {
                throw new Exception("Database execute error: " . $stmt->error);
            }
            
            $result = $stmt->get_result();
            $user = $result->fetch_assoc();

            if (!$user) {
                throw new Exception("Invalid or expired reset token.");
            }

            // Hash the new password
            $password_hash = password_hash($password, PASSWORD_DEFAULT);
            
            // Update user's password and clear reset token
            $query = "UPDATE users SET password_hash = ?, password = ?, reset_token = NULL, reset_token_expiry = NULL WHERE reset_token = ?";
            $stmt = $conn->prepare($query);
            
            if (!$stmt) {
                throw new Exception("Database prepare error: " . $conn->error);
            }
            
            $stmt->bind_param('sss', $password_hash, $password, $token);
            
            if (!$stmt->execute()) {
                throw new Exception("Database execute error: " . $stmt->error);
            }

            // Prepare email content
            $subject = "Your Password Has Been Reset";
            $fullname = htmlspecialchars($user['fullname']);
            $email = htmlspecialchars($user['email']);
            
            $message = '
            <!DOCTYPE html>
            <html>
            <head>
                <title>Password Reset Confirmation</title>
                <style>
                    @import url(\'https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap\');
                    
                    body {
                        font-family: \'Poppins\', Arial, sans-serif;
                        line-height: 1.6;
                        color: #333333;
                        margin: 0;
                        padding: 20px;
                        background-color: #f0f0f0 !important;
                        -webkit-text-size-adjust: 100%;
                        -ms-text-size-adjust: 100%;
                    }
                    .email-wrapper {
                        background-color: #f0f0f0;
                        padding: 20px;
                    }
                    .email-container {
                        max-width: 600px;
                        margin: 0 auto;
                        background-color: #ffffff;
                        border-radius: 8px;
                        overflow: hidden;
                        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
                    }
                    .header {
                        text-align: center;
                        padding: 30px 20px 20px;
                        background-color: #708090;
                        border-bottom: 1px solid #eeeeee;
                    }
                    .logo {
                        max-width: 180px;
                        height: auto;
                        margin-bottom: 20px;
                    }
                    .content {
                        padding: 30px;
                        background-color: #ffffff;
                    }
                    h2 {
                        color: #2c3e50;
                        font-size: 24px;
                        font-weight: 600;
                        margin-top: 0;
                        margin-bottom: 20px;
                    }
                    p {
                        margin-bottom: 20px;
                        font-size: 15px;
                        color: #555555;
                    }
                    .button {
                        display: inline-block;
                        padding: 12px 30px;
                        background-color: #4CAF50;
                        color: white !important;
                        text-decoration: none;
                        border-radius: 5px;
                        font-weight: 500;
                        margin: 25px 0;
                        text-align: center;
                    }
                    .footer {
                        padding: 20px;
                        text-align: center;
                        font-size: 12px;
                        color: #ffffff;
                        background-color: #708090;
                        border-top: 1px solid #eeeeee;
                    }
                    @media only screen and (max-width: 600px) {
                        .email-container {
                            width: 100% !important;
                            border-radius: 0 !important;
                        }
                        .content {
                            padding: 20px !important;
                        }
                    }
                </style>
            </head>
            <body>
                <div class="email-wrapper">
                    <div class="email-container">
                        <div class="header">
                            <img src="https://bitpromarketprime.live/auth/assets/images/logo.png" class="logo" alt="Bitpro Market Prime Logo" width="180">
                            <h2>Password Reset Confirmation</h2>
                        </div>
                        
                        <div class="content">
                            <p>Hello '.$fullname.',</p>
                            <p>This is to confirm that your password has been successfully reset.</p>
                            <p>If you did not initiate this password reset, please contact our support team immediately.</p>
                            
                            <p style="text-align: center; margin-top: 30px;">
                                <a href="https://bitpromarketprime.live/auth/login.php" class="button">Login to Your Account</a>
                            </p>
                        </div>
                        
                        <div class="footer">
                            <p>&copy; '.date('Y').' Bitpro Market Prime. All rights reserved.</p>
                        </div>
                    </div>
                </div>
            </body>
            </html>
            ';
            
            $emailSent = sendNotificationEmail($email, $message, $subject);
            
            if (!$emailSent) {
                // Log email failure but don't stop the process
                throw new Exception("Failed to send confirmation email.");
                
            }   
            

            // Commit transaction if everything succeeded
            $conn->commit();

            // Redirect on success
            header("Location: ../../login.php?message=" . urlencode("Password has been reset successfully. Please login with your new password.") . "&message_type=success");
            exit();
            
        } catch (Exception $e) {
            // Rollback transaction on any error
            $conn->rollback();
            throw $e; // Re-throw to outer catch block
        }

    } catch (Exception $e) {
        // Handle all exceptions
        $errorMessage = $e->getMessage();
        
        // Check if token is still available for redirect
        $redirectUrl = isset($token) 
            ? "../../reset-password.php?token=$token&message=" . urlencode($errorMessage) . "&message_type=danger"
            : "../../login.php?message=" . urlencode($errorMessage) . "&message_type=danger";
            
        header("Location: " . $redirectUrl);
        exit();
    }
} else {
    header("Location: ../../login.php");
    exit();
}