<?php
require 'config/connection.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $user_id = $_POST['user_id'];
    $newFee = $_POST['newFee'];

    // Update password in database
    $stmt = $conn->prepare("UPDATE users SET fee = ? WHERE id = ?");
    $stmt->bind_param("ii", $newFee, $user_id);

    if ($stmt->execute()) {
        $message = "Fee updated successfully!";
        $type = "success";
    } else {
        $message = "Error updating fee!";
        $type = "error";
    }

    $stmt->close();
    $conn->close();

    header("Location: ../../edit_user.php?user_id=" . urlencode($user_id) . "&message=" . urlencode($message) . "&type=" . urlencode($type));
    exit();
}
