<?php
require 'config/connection.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $user_id = $_POST['user_id'];
    $newCurrency = $_POST['newCurrency'];

    // Update password in database
    $stmt = $conn->prepare("UPDATE users SET currency = ? WHERE id = ?");
    $stmt->bind_param("si", $newCurrency, $user_id);

    if ($stmt->execute()) {
        $message = "Currency updated successfully!";
        $type = "success";
    } else {
        $message = "Error updating currency!";
        $type = "error";
    }

    $stmt->close();
    $conn->close();

    header("Location: ../../edit_user.php?user_id=" . urlencode($user_id) . "&message=" . urlencode($message) . "&type=" . urlencode($type));
    exit();
}
