<?php
require 'config/connection.php'; // Database connection

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $trader_id = (int) $_POST['copy_trader_id'];
    $name = trim($_POST['name']);
    $win_rate = (float) $_POST['win_rate'];
    $profit_percent = (float) $_POST['profit_percent'];

    // Validate inputs
    if ($trader_id <= 0 || empty($name) || $win_rate < 0 || $profit_percent < 0) {
        die("Invalid input values.");
    }

    // Initialize SQL and bind types
    $sql = "UPDATE copy_traders SET trader_name=?, win_rate=?, profit_percent=?";
    $types = "sdd";
    $params = [$name, $win_rate, $profit_percent];

    // Handle image upload if a file is provided
    if (isset($_FILES['trader_image']) && $_FILES['trader_image']['error'] === UPLOAD_ERR_OK) {
        $image = $_FILES['trader_image'];
        $imageName = basename($image['name']);
        $targetDir = '../../../assets/copy_trader_images/';
        $targetFile = $targetDir . uniqid() . "_" . $imageName;

        // Validate image type (optional: add size and dimension checks)
        $imageFileType = strtolower(pathinfo($targetFile, PATHINFO_EXTENSION));
        $allowedTypes = ['jpg', 'jpeg', 'png', 'gif'];

        if (!in_array($imageFileType, $allowedTypes)) {
            die("Only JPG, JPEG, PNG, and GIF files are allowed.");
        }

        if (!move_uploaded_file($image['tmp_name'], $targetFile)) {
            die("Failed to upload image.");
        }

        // Append to SQL for image update
        $sql .= ", trader_image=?";
        $types .= "s";
        $params[] = $targetFile;
    }

    // Finalize the SQL with WHERE clause
    $sql .= " WHERE id=?";
    $types .= "i";
    $params[] = $trader_id;

    // Prepare and bind
    $stmt = $conn->prepare($sql);
    $stmt->bind_param($types, ...$params);

    if ($stmt->execute()) {
        $message = "Copy Trader updated successfully";
        $type = "success";
    } else {
        $message = "Error updating Copy Trader!";
        $type = "error";
    }

    $stmt->close();
    $conn->close();

    header("Location: ../../copy_traders.php?message=" . urlencode($message) . "&type=" . urlencode($type));
    exit();
}